package topdown.operator;

import topdown.data_structures.*;
import topdown.concrete_operator.*;
import topdown.term.Term;

import java.util.ArrayList;
import java.util.List;

public class AntiJoin implements Operator {
    // "Big AntiJoin"
    private final List<Operator> operators;
    private final List<List<Term>> inputV;
    private final List<Term> outputV;

    public AntiJoin(List<Operator> operators, List<List<Term>> inputV, List<Term> outputV) {
        this.operators = operators;
        this.inputV = inputV;
        this.outputV = outputV;
    }

    @Override
    public ConcreteOperator instance() {
        List<ConcreteOperator> concreteOperators = new ArrayList<>();
        for (Operator op : operators) {
            concreteOperators.add(op.instance());
        }

        ConcreteAntiJoin result = new ConcreteAntiJoin(
                concreteOperators, inputV, outputV
        );
        result.reset();
        return result;
    }

    @Override
    public ConcreteOperator instance(int U, int L) {
        if (U <= 0 || L <= 0) return new EmptyOperator();

        List<ConcreteOperator> concreteOperators = new ArrayList<>();
        concreteOperators.add(concreteOperators.getFirst().instance(U, L));
        for (int i = 1; i < concreteOperators.size(); i++) {
            int previousL = 2;
            while (concreteOperators.get(i).changes(U - 1, previousL)) previousL++;

            concreteOperators.add(concreteOperators.get(i).instance(U-1, previousL));
        }

        ConcreteAntiJoin result = new ConcreteAntiJoin(
                concreteOperators, inputV, outputV
        );

        return result;

    }

    @Override
    public boolean changes(int U, int L) {
        for (Operator op : operators) {
            if (op.changes(U, L)) return true;
        }

        return false;
    }

    @Override
    public boolean changes(int U) {
        for (Operator op : operators) {
            if (op.changes(U)) return true;
        }

        return false;
    }

}
